unit graf_fx;

interface

{// M O J E   T Y P Y   D A N Y C H
{///////////////////////////////////////////////////////}

type wielka_tablica = array[0..63999] of byte;

type obraz = record
              szerokosc : word;
              wysokosc : word;
              wsk_obrazu : ^wielka_tablica;
              rozmiar : word;
             end;

type naglowek_pliku_BMP = record
                           typ_obrazu : array[0..1] of char;
                           rozmiar_pliku : longint;
                           zarezerwowane1 : word;
                           zarezerwowane2 : word;
                           odleglosc_do_obrazu : longint;
                           rozmiar_naglowka_info : longint;
                           szerokosc_obrazu : longint;
                           wysokosc_obrazu : longint;
                           liczba_planow_obrazu : word;
                           liczba_bitow_na_piksel : word;
                           typ_kompresji : longint;
                           rozmiar_obrazu : longint;
                           pozioma_rozdziel_DPI : longint;
                           pionowa_rozdziel_DPI : longint;
                           liczba_uzywanych_kolorow : longint;
                           liczba_znaczacych_kolorow : longint;
                          end;

type wzorzec_koloru_BMP = record
                           niebieski : byte;
                           zielony : byte;
                           czerwony : byte;
                           zarezerwowany : byte;
                          end;

type wzorzec_koloru = record
                       czerwony : byte;
                       zielony : byte;
                       niebieski : byte;
                      end;

type prostokat = record
                  x : integer;
                  y : integer;
                  szerokosc : integer;
                  wysokosc : integer;
                 end;

{// N A G L O W K I  P R O C E D U R  I  F U N K C J I}
{///////////////////////////////////////////////////////}

procedure g_ustaw_tryb_vga(tryb : byte);
procedure g_rysuj_piksel_13h( x, y : word; kolor : byte);
procedure g_rysuj_pozioma_linia_13h(x1, x2, y : word; kolor : byte);
procedure g_rysuj_pionowa_linia_13h(x, y1, y2 : word; kolor : byte);
procedure g_zamaluj_ekran_13h(kolor : byte);
procedure g_laduj_BMP_13h( var z_obraz : obraz; szciezka : string);
procedure g_laduj_palete_BMP( szciezka : string);
procedure g_wypelnij_p(var p : prostokat; x, y, s, w : integer);
procedure g_wyswietl_obraz_13h(wsk_buforu : pointer; zrodlo, cel : prostokat; rys : obraz);
procedure g_zwolnij_pam( rys : obraz);
procedure g_wyswietl_obraz_13h_k(wsk_buforu : pointer; zrodlo, cel : prostokat;
                                 rys : obraz; czy_p_kolor : boolean; p_kolor : byte);
procedure g_wyswietl_obraz_13h_k_s(wsk_buforu : pointer; zrodlo, cel : prostokat;
                                   rys : obraz; czy_p_kolor : boolean; p_kolor : byte);

implementation

procedure g_ustaw_tryb_vga(tryb : byte);
begin
asm

mov ah, 00h  {zaladuj 00h do AH - numer funkcji przerwania 10h}
mov al, tryb {zaladuj tryb do AL - numer trybu pracy karty graficznej}
int 10h      {wywolaj przerwanie 10h}

end;
end; {koniec procedury g_ustaw_tryb_vga}

{--------------}

procedure g_rysuj_piksel_13h( x, y : word; kolor : byte);
begin
asm

mov ax, y                {zaladuj y do AX}
mov di, ax               {zaladuj AX do DI}
shl ax, 8                {przesun bity rejestru AX 8 pozycji w lewo}
shl di, 6                {przesun bity rejestru DI 6 pozycji w lewo}
add di, ax               {dodaj AX do DI}
add di, x                {dodaj x do DI}
mov ax, 0a000h           {zaladuj A000 do AX}
mov es, ax               {zaladuj AX do ES}
mov al, kolor            {zaladuj kolor do AL}
mov byte ptr es:[di], al {zapisz pod adres ES:DI warto rejestru AL}

end;
end; {koniec procedury g_rysuj_piksel_13h}

{--------------}

procedure g_rysuj_pozioma_linia_13h(x1, x2, y : word; kolor : byte);
begin
asm
mov cx, x2        {zaladuj x2 do CX}
sub cx, x1        {odejmij x1 od CX i umiesc wynik w CX}
add cx, 1         {dodaj 1 do CX}
mov ax,y          {zaladuj y do AX}
mov di,ax         {zaladuj AX do DI}
shl ax,8          {przesun bity rejestru AX o 8 pozycji w lewo}
shl di,6          {przesun bity rejestru DI o 6 pozycji w lewo}
add di,ax         {dodaj AX do DI}
add di,x1         {dodaj x do DI}
mov ax,0a000h     {zaladuj A000 do AX}
mov es,ax         {zaladuj AX do ES}
mov al, kolor     {zaladuj kolor do AL}
cld               {wyzeruj znacznik kierunku - adresy rosnace}
rep stosb         {zapisz CX razy wartosc rejestru AL do komorek
                   pamieci spod adresu ES:DI}
end;
end; {koniec procedury g_rysuj_pozioma_linia_13h}

{--------------}

procedure g_rysuj_pionowa_linia_13h(x, y1, y2 : word; kolor : byte);
begin
asm

mov cx, y2        {zaladuj y2 do CX}
sub cx, y1        {odejmij y1 od CX}
add cx, 1         {dodaj 1 do CX}
mov ax, y1        {zaladuj 1 do AX}
mov di, ax        {zaladuj AX do DI}
shl ax, 8         {przesun bity rejestru AX 8 pozycji w lewo}
shl di, 6         {przesun bity rejestru DI 6 pozycji w lewo}
add di, ax        {dodaj AX do DI}
add di, x         {dodaj x do DI}
mov ax, 0a000h    {zaladuj A000 do AX}
mov es, ax        {zaladuj AX do ES}
mov al, kolor     {zaladuj kolor do AL}

@rysuj_linie:     {definicja etykiety}
mov es:[di], al   {zapisz AL do komorki pamieci o adresie ES:DI}
add di, 320       {dodaj 320 do DI}
loop @rysuj_linie {zmiejsz CX o 1, jezeli rozny od 0 skocz do etykiety rysuj_linie}

end;
end; {koniec procedury g_rysuj_pionowa_linia_13h}

{--------------}

procedure g_zamaluj_ekran_13h(kolor : byte);
begin
asm

mov ax, 0A000h   {zaladuj A000h do AX}
mov es, ax       {zaladuj AX do ES}
mov di, 0        {zaladuj 0 do DI}
mov cx, 32000    {zaladuj 32000 do CX} 
mov ah, kolor    {zaladuj kolor do AH}
mov al, ah       {zaladuj AH, do AL}
cld              {ustwa znacznik kierunku - adres rosnacy}
rep stosw        {zapisz CX razy wartosc rejstru AX do kmorek spod
                  adresu ES:DI, zwieksz DI o 2}
end;
end; {koniec procedury g_zamaluj_ekran_13h}

{--------------}

procedure g_laduj_BMP_13h( var z_obraz : obraz; szciezka : string);
var
plik : file;
naglowek : naglowek_pliku_BMP;
licznik, wynik : word;
licznik_odczytu : word;
begin

{Skojarzenie zbiory ze zmienna plikowa i otworzenie go}
assign(plik, szciezka);
reset(plik, 1);

{odczyt naglowka bitmapy}
licznik := sizeof(naglowek_pliku_BMP);
blockread(plik, naglowek, licznik, wynik);

{Sprawdzenie czy rozmiary obrazu sa zgodne z rozdzielczoscia ekranu }
if((naglowek.szerokosc_obrazu > 320) or
   (naglowek.wysokosc_obrazu > 200)) then
   begin
   close(plik);   {zamkniecie pliku}
   exit;          {opuszczenie procedury}
   end;  {koniec if then}

{przeskakujemy palete kolorow}
seek(plik,1078);

{zapisanie rozmiarow obrazu i oblicznie rozmiaru bloku pamieci
 potrzebnego do przechowywania obrazu}
z_obraz.szerokosc := naglowek.szerokosc_obrazu;
z_obraz.wysokosc := naglowek.wysokosc_obrazu;
z_obraz.rozmiar := naglowek.szerokosc_obrazu * naglowek.wysokosc_obrazu;

{Sparwdzamy czy system posiada dosc wolen pamieci do przechowywania
 ladowanego obrazu bitmapy, jezeli jest jej zamalo opuszczamy procedure}
if(maxavail < z_obraz.rozmiar) then
   begin
   close(plik);  {zamkniecie pliku}
   exit;         {opuszczenie procedury}
   end;  {koniec if then}

{przydzielenie pamieci dla obrazu}
getmem(z_obraz.wsk_obrazu, z_obraz.rozmiar);

{zaladowanie obrazu - obraz podczas odczytu zostaje odwrucony w pionie}
licznik := naglowek.szerokosc_obrazu;
for licznik_odczytu := 0 to naglowek.wysokosc_obrazu - 1 do
begin
blockread(plik, z_obraz.wsk_obrazu^[(naglowek.wysokosc_obrazu - 1 - licznik_odczytu) * z_obraz.szerokosc], licznik, wynik);
end; {koniec petli for}

{zamkniecie pliku}
close(plik);

end; {koniec procedury g_laduj_BMP_13h}

{--------------}

procedure g_laduj_palete_BMP( szciezka : string);
var
plik : file;
paleta_k : array[0..255] of wzorzec_koloru_BMP;
licznik, wynik : word;
begin

{skojarzenie zmiennej plikowej plik ze zbiorem danych okreslonym
 przez parametr szciezka}
assign(plik, szciezka);

{otwarcie pliku}
reset(plik, 1);

{przesowa wskaznik pozycji pliku na pierwszy bajt palety kolorow}
seek(plik, sizeof(naglowek_pliku_BMP));

{ustalmy liczbe odczytywanych bajtow na rowna rozmiarowi zmiennej pleta_k}
licznik := sizeof(paleta_k);

{odczytanie palety kolorow}
blockread(plik, paleta_k,licznik, wynik);

{zapis palety kolorow do karty vga zaczynamy od pierwszego wzorca koloru}
port[$3c8] := 0;

{petla wysylajaca do portow karty graficznej palete kolorow}
for licznik :=  0 to 255 do
begin
port[$3c9] := paleta_k[licznik].czerwony shr 2;
port[$3c9] := paleta_k[licznik].zielony shr 2;
port[$3c9] := paleta_k[licznik].niebieski shr 2;
end; {koniec petli for}

{zamknij plik}
close(plik);

end; {koniec procedury g_laduj_palete_BMP}

{--------------}

procedure g_wypelnij_p(var p : prostokat; x, y, s, w : integer);
begin

p.x := x;
p.y := y;
p.szerokosc := s;
p.wysokosc := w;

end; {koniec procedury g_wypelnij_p}

{--------------}

procedure g_wyswietl_obraz_13h(wsk_buforu : pointer;
                     zrodlo, cel : prostokat;
                     rys : obraz);
var
licznik_y : word;
start_zrodlo, start_bufor : word;
przeskok_zrodlo : word;
przeskok_bufor : word;
zmiana_x, zmiana_y : word;
_wsk_obrazu : pointer;
_szerokosc : integer;
begin
zmiana_x := 0;
zmiana_y := 0;
_wsk_obrazu := rys.wsk_obrazu;

{obciecie docelowego prostokata obrazu do wymiarow ekranu}

{- nie rysujemy dla prostokata, ktory nie znajdujacego sie w przestrzeni ekranu}
if(cel.x > 319) then exit;
if(cel.y > 199) then exit;
if(cel.x + cel.szerokosc <= 0) then exit;
if(cel.y + cel.wysokosc <= 0) then exit;

{- jezeli wystaje za lewa krawedz ekranu}
if(cel.x < 0) then
begin
cel.szerokosc := cel.szerokosc + cel.x;
zmiana_x := -cel.x;
cel.x := 0;
end;

{- jezeli wystaje za gorna krawedz ekranu}
if(cel.y < 0) then
begin
cel.wysokosc := cel.wysokosc + cel.y;
zmiana_y  := -cel.y;
cel.y := 0;
end;

{- jezeli wystaje za prawa krawedz ekranu}
if( (cel.x + cel.szerokosc) > 319) then cel.szerokosc := 320 - cel.x;

{- jezeli wystaje za dolna krawedz ekranu}
if( (cel.y + cel.wysokosc) > 199) then cel.wysokosc := 200 - cel.y;

{obliczenie przesuniecia w bajtach pierwszego piksela rysowanego fragmentu obrazu}
start_zrodlo := zrodlo.x + zmiana_x + ((zrodlo.y + zmiana_y) * rys.szerokosc);

{obliczenie przesuniecia w bajtach rysowanego obrazu w buforze ekranu}
start_bufor := cel.x + cel.y * 320;

{oblicznie przesuniecia miedzy kolejnymi linia w obrazie}
przeskok_zrodlo := zrodlo.szerokosc;
if (zrodlo.x > 0) then przeskok_zrodlo := przeskok_zrodlo + zrodlo.x;
if (zrodlo.x + zrodlo.szerokosc <= rys.szerokosc - 1) then
    przeskok_zrodlo := przeskok_zrodlo + rys.szerokosc - (zrodlo.x + zrodlo.szerokosc);

{obliczenie przesuniecia miedzy kolejnymi liniami w buforze ekranu}
przeskok_bufor := cel.szerokosc;
if (cel.x > 0 ) then przeskok_bufor := przeskok_bufor + cel.x;
if (cel.x + cel.szerokosc <= 319) then przeskok_bufor := przeskok_bufor + 320 - (cel.x + cel.szerokosc);

_szerokosc := cel.szerokosc;
{przenoszenie rysunku z pamieci obrazu do pamieci bufora ekranu}
for licznik_y := 0 to cel.wysokosc - 1 do
begin

asm
push ds              {odluz wartosc DS na stos}
les di, wsk_buforu   {zaladuj adres bufora ekranu, segment do ES, offset do DI}
add di, start_bufor  {dodaj start_bufor do DI}
lds si, _wsk_obrazu  {zaladuj adres bufora obrazu, segemnt do DS, offset do SI}
add si, start_zrodlo {dodaj start_zrodlo do SI}
mov cx, _szerokosc   {zaladuj _szerokosc do CX - liczba kopiowanych bajtow}
cld                  {zeruj znacznik kierunku - DF, adresy rosnace}
rep movsb            {kopiowanie bajtow}
pop ds               {zaladuj DS wartoscia ze stosu}
end;

{po narysowaniu kazdej lini uaktualniamy adres odczytu i adres zapisu pikseli}
start_zrodlo := start_zrodlo + przeskok_zrodlo;
start_bufor := start_bufor + przeskok_bufor;
end; {koniec petli for licznik_y}

end; {koniec procedury g_wyswietl_obraz_13h}

{--------------}

procedure g_zwolnij_pam( rys : obraz);
begin

freemem(rys.wsk_obrazu, rys.rozmiar);

end; {koniec procedury g_zwolnij_pam}

{--------------}

procedure g_wyswietl_obraz_13h_k(wsk_buforu : pointer;
                     zrodlo, cel : prostokat;
                     rys : obraz; czy_p_kolor : boolean;
                     p_kolor : byte);
var
licznik_y : word;
start_zrodlo, start_bufor : word;
przeskok_zrodlo : word;
przeskok_bufor : word;
zmiana_x, zmiana_y : word;
_wsk_obrazu : pointer;
_szerokosc : integer;
begin
zmiana_x := 0;
zmiana_y := 0;
_wsk_obrazu := rys.wsk_obrazu;

{obciecie docelowego prostokata obrazu do wymiarow ekranu}

{- nie rysujemy dla prostokata, ktory nie znajdujacego sie w przestrzeni ekranu}
if(cel.x > 319) then exit;
if(cel.y > 199) then exit;
if(cel.x + cel.szerokosc <= 0) then exit;
if(cel.y + cel.wysokosc <= 0) then exit;

{- jezeli wystaje za lewa krawedz ekranu}
if(cel.x < 0) then
begin
cel.szerokosc := cel.szerokosc + cel.x;
zmiana_x := -cel.x;
cel.x := 0;
end;

{- jezeli wystaje za gorna krawedz ekranu}
if(cel.y < 0) then
begin
cel.wysokosc := cel.wysokosc + cel.y;
zmiana_y  := -cel.y;
cel.y := 0;
end;

{- jezeli wystaje za prawa krawedz ekranu}
if( (cel.x + cel.szerokosc) > 319) then cel.szerokosc := 320 - cel.x;

{- jezeli wystaje za dolna krawedz ekranu}
if( (cel.y + cel.wysokosc) > 199) then cel.wysokosc := 200 - cel.y;

{obliczenie przesuniecia w bajtach pierwszego piksela rysowanego fragmentu obrazu}
start_zrodlo := zrodlo.x + zmiana_x + ((zrodlo.y + zmiana_y) * rys.szerokosc);

{obliczenie przesuniecia w bajtach rysowanego obrazu w buforze ekranu}
start_bufor := cel.x + cel.y * 320;

{oblicznie przesuniecia miedzy kolejnymi linia w obrazie}
przeskok_zrodlo := zrodlo.szerokosc;
if (zrodlo.x > 0) then przeskok_zrodlo := przeskok_zrodlo + zrodlo.x;
if (zrodlo.x + zrodlo.szerokosc <= rys.szerokosc - 1) then
    przeskok_zrodlo := przeskok_zrodlo + rys.szerokosc - (zrodlo.x + zrodlo.szerokosc);

{obliczenie przesuniecia miedzy kolejnymi liniami w buforze ekranu}
przeskok_bufor := cel.szerokosc;
if (cel.x > 0 ) then przeskok_bufor := przeskok_bufor + cel.x;
if (cel.x + cel.szerokosc <= 319) then przeskok_bufor := przeskok_bufor + 320 - (cel.x + cel.szerokosc);

_szerokosc := cel.szerokosc;
if (czy_p_kolor = FALSE) then {czy uwzglednic przezroczysty kolor}
begin
{przenoszenie rysunku z pamieci obrazu do pamieci bufora ekranu}
for licznik_y := 0 to cel.wysokosc - 1 do
begin

asm
push ds              {odluz wartosc DS na stos}
les di, wsk_buforu   {zaladuj adres bufora ekranu, segment do ES, offset do DI}
add di, start_bufor  {dodaj start_bufor do DI}
lds si, _wsk_obrazu  {zaladuj adres bufora obrazu, segemnt do DS, offset do SI}
add si, start_zrodlo {dodaj start_zrodlo do SI}
mov cx, _szerokosc   {zaladuj _szerokosc do CX - liczba kopiowanych bajtow}
cld                  {zeruj znacznik kierunku - DF, adresy rosnace}
rep movsb            {kopiowanie bajtow}
pop ds               {zaladuj DS wartoscia ze stosu}
end;

{po narysowaniu kazdej lini uaktualniamy adres odczytu i adres zapisu pikseli}
start_zrodlo := start_zrodlo + przeskok_zrodlo;
start_bufor := start_bufor + przeskok_bufor;
end; {koniec petli for licznik_y}

end else {jesli czy_p_kolor = TRUE}
begin
{przenoszenie rysunku z pamieci obrazu do pamieci bufora ekranu}
for licznik_y := 0 to cel.wysokosc - 1 do
begin

asm
push ds              {odluz wartosc DS na stos}

les di, wsk_buforu   {zaladuj adres bufora ekranu, segment do ES, offset do DI}
add di, start_bufor  {dodaj start_bufor do DI}
lds si, _wsk_obrazu  {zaladuj adres bufora obrazu, segemnt do DS, offset do SI}
add si, start_zrodlo {dodaj start_zrodlo do SI}
mov cx, _szerokosc   {zaladuj _szerokosc do CX - liczba kopiowanych bajtow}
mov ah, p_kolor           {zaladuj p_kolor do AH}

@petla:                   {definicja etykiety petla }
mov al, byte ptr ds:[si]  {zaladuj do AL bajt z pod adresu DS:SI}
cmp al, ah                {porowanaj AL z AH}
jz @przezroczysty         {jezeli AL jest rowne AH to skocz do etykiety przezroczysty}
mov byte ptr es:[di], al  {zapisz pod adres ES:DI wartosc rejestru AL}
@przezroczysty:           {definicja etykiety przezroczysty}
inc di                    {zwieksz DI o 1}
inc si                    {zwieksz SI o 1}
loop @petla               {zmiejsz CX i skocz do etykiety petla}

pop ds               {zaladuj DS wartoscia ze stosu}
end;

{po narysowaniu kazdej lini uaktualniamy adres odczytu i adres zapisu pikseli}
start_zrodlo := start_zrodlo + przeskok_zrodlo;
start_bufor := start_bufor + przeskok_bufor;
end; {koniec petli for licznik_y}
end;

end; {koniec procedury g_wyswietl_obraz_13h_k}

{--------------}

procedure g_wyswietl_obraz_13h_k_s(wsk_buforu : pointer;
                     zrodlo, cel : prostokat;
                     rys : obraz; czy_p_kolor : boolean;
                     p_kolor : byte);
var
licznik_y,licznik_x : word;
stosunek_x, stosunek_y : real;
start_zrodlo : real;
start_bufor : word;
z_stosunek_y : real;
przeskok_zrodlo : word;
przeskok_bufor : word;
piksel : byte;
begin
z_stosunek_y := 0;

{zmiejszenie docelowego prostokata obrazu do wymiarow ekranu}
if ((cel.x < 0) or (cel.x > 319)) then exit;
if ((cel.y < 0) or (cel.y > 199)) then exit;

if ((cel.x + cel.szerokosc > 319)) then cel.szerokosc := 320 - cel.x;
if ((cel.y + cel.wysokosc > 199)) then cel.wysokosc := 200 - cel.y;

{obliczenie stosunkow rozdzielczosci zrodlowego prostokata do rozdzielczosci
 prostokata docelowego}
stosunek_x := zrodlo.szerokosc / cel.szerokosc;
stosunek_y := zrodlo.wysokosc / cel.wysokosc;

{obliczenie przesuniecia w bajtach pierwszego piksela rysowanego fragmentu obrazu}
start_zrodlo := zrodlo.x + (zrodlo.y * rys.szerokosc);

{obliczenie przesuniecia w bajtach pierwszego piksela rysowanego w buforze ekranu}
start_bufor := cel.x + (cel.y * 320);

{oblicznie przesuniecia miedzy kolejnymi linia w obrazie}
przeskok_zrodlo := zrodlo.szerokosc;
if (zrodlo.x > 0) then przeskok_zrodlo := przeskok_zrodlo + zrodlo.x;
if (zrodlo.x + zrodlo.szerokosc <= rys.szerokosc - 1) then
    przeskok_zrodlo := przeskok_zrodlo + rys.szerokosc - (zrodlo.x + zrodlo.szerokosc);

{obliczenie przesuniecia miedzy kolejnymi liniami w buforze ekranu}
przeskok_bufor := 0;
if (cel.x > 0 ) then przeskok_bufor := przeskok_bufor + cel.x;
if (cel.x + cel.szerokosc <= 319) then przeskok_bufor := przeskok_bufor + 320 - (cel.x + cel.szerokosc);

if (czy_p_kolor = FALSE) then {czy uwzglednic przezroczysty kolor}
begin
{przenoszenie rysunku z pamieci obrazu do pamieci bufora ekranu bez
 uwzgledniania przezroczystego koloru}
for licznik_y := 0 to cel.wysokosc - 1 do
begin
for licznik_x := 0 to cel.szerokosc - 1 do
begin

{pobierz piksel z bufora obrazu}
piksel := rys.wsk_obrazu^[trunc(start_zrodlo)];

asm
les di, wsk_buforu        {zaladuj adres bufora ekranu, segment do ES, offset do DI}
add di, start_bufor       {dodaj start_bufor do DI}
mov ah, piksel            {zaladuj piksel do AH}
mov byte ptr es:[di], ah  {zaladuj AH do komorki spod adresu ES:DI}
inc start_bufor           {zwieksz o 1 zmienna start_bufor}
end;

{przesowamy sie w prawo rysujac kolejne piksele}
start_zrodlo := start_zrodlo + stosunek_x;

end; {koniec petli for licznik_x}

{po narysowaniu kazdej lini uaktualniamy adres odczytu i adres zapisu pikseli}
z_stosunek_y := z_stosunek_y + stosunek_y;
if (trunc(z_stosunek_y) >= 1.0) then
begin
start_zrodlo := start_zrodlo + (trunc(z_stosunek_y) * przeskok_zrodlo) - zrodlo.szerokosc;
z_stosunek_y := z_stosunek_y - trunc(z_stosunek_y);
end else start_zrodlo := start_zrodlo - zrodlo.szerokosc;

start_bufor := start_bufor + przeskok_bufor;
end; {koniec petli for licznik_y}

end else {jesli czy_p_kolor = TRUE}
begin

{przenoszenie rysunku z pamieci obrazu do pamieci bufora ekranu z
 uwzglednieniem przezroczystego koloru}
for licznik_y := 0 to cel.wysokosc - 1 do
begin
for licznik_x := 0 to cel.szerokosc - 1 do
begin

{pobierz piksel z bufora obrazu}
piksel := rys.wsk_obrazu^[trunc(start_zrodlo)];

asm
les di, wsk_buforu        {zaladuj adres bufora ekranu, segment do ES, offset do DI}
add di, start_bufor       {dodaj start_bufor do DI}
mov ah, piksel            {zaladuj piksel do AH}
cmp p_kolor, ah           {porownaj p_kolor z AH}
jz @przezroczysty         {jezeli p_kolor = AH to skocz do etykiety przezroczysty}
mov byte ptr es:[di], ah  {zaladuj AH do komorki spod adresu ES:SI}
@przezroczysty:           {definicja etykiety przezroczysty}
inc start_bufor           {zwieksz o 1 zmienna start_bufor}
end;

start_zrodlo := start_zrodlo + stosunek_x;

end; {koniec petli for licznik_x}

{po narysowaniu kazdej lini uaktualniamy adres odczytu i adres zapisu pikseli}
z_stosunek_y := z_stosunek_y + stosunek_y;
if (trunc(z_stosunek_y) >= 1.0) then
begin
start_zrodlo := start_zrodlo + (trunc(z_stosunek_y) * przeskok_zrodlo) - zrodlo.szerokosc;
z_stosunek_y := z_stosunek_y - trunc(z_stosunek_y);
end else start_zrodlo := start_zrodlo - zrodlo.szerokosc;

start_bufor := start_bufor + przeskok_bufor;
end; {koniec petli for licznik_y}

end; {koniec bloku else}

end; {koniec procedury g_wyswietl_obraz_13h_k_s}

end. {koniec modulu}

